PROC TABULATE DATA=ghpb10 NOSEPS MISSING;                                                                                                                                                      
CLASS COLLECTIVE_BARGAIN_IND_E INS3 ENT2 filingsize; 
TITLE 'Table A8. Number of Group Health Plans and Total Participants';
title2 'by collective bargaining status, type of insurance, and type of plan, 2010';
KEYWORD ALL / STYLE=[font_size=2 font_weight=bold foreground=black];                                                                                                                                    
KEYLABEL ALL='Total';       
var subtl_act_rtd_sep_CNE; 
TABLE all='All Plans' filingsize=' ',
	  (ALL COLLECTIVE_BARGAIN_IND_E='')*(ALL ENT2=' '),                                                                                                                                                                   
      (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (N='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year (thousands)'*F=K12f.))                                                                                                                    
      / Box={label='Collective Bargaining Status / Plan Entity'} RTS=20 MISSTEXT='-';                                                                                                                                 
RUN;  
